
layout(push_constant) uniform Push
{
   // User Settings
   float hcrt_hdr;
   float hcrt_colour_space;
   float hcrt_colour_system;
   float hcrt_colour_accurate;
   float hcrt_max_nits;
   float hcrt_paper_white_nits;
   float hcrt_expand_gamut;
   float hcrt_gamma_out;
   float hcrt_white_temperature;
   float hcrt_brightness;
   float hcrt_contrast;
   float hcrt_saturation;
   float hcrt_gamma_in;
} params;

// #pragma parameter hcrt_color_settings                "[ COLOR SETTINGS HDR/SDR INPUT/OUTPUT by MajorPainTheCactus ]:"                                     0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_space0                        " "                                                            0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_support0                      "If image is dark, try turning up your TV's brightness"               0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_support1                      "HDR mode: Set the peak luminance to that of your TV."         0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_support2                      "Then adjust paper white luminance until it looks right"       0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_support3                      " "                                                            0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_support4                      "Default white points for the different colour systems:"       0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_support5                      "    709, PAL & NTSC-U: 6500K, NTSC-J: 9300K"         0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_space1                        " "                                                            0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_user_settings                 "[ YOUR DISPLAY'S SETTINGS ]:"                                     0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_hdr                           "    SDR | HDR"                                                0.0      0.0   1.0      1.0
#pragma parameter hcrt_colour_accurate               "    Mask Accurate/Colour Accurate"                            1.0      0.0   1.0      1.0
#pragma parameter hcrt_colour_space                  "         Display's Colour Space: r709 | sRGB | DCI-P3"        1.0      0.0   2.0      1.0
#pragma parameter hcrt_max_nits                      "    HDR: Display's Peak Luminance"                            1000.0    0.0   10000.0  10.0
#pragma parameter hcrt_paper_white_nits              "    HDR: Display's Paper White Luminance"                     200.0    0.0   10000.0  10.0
#pragma parameter hcrt_expand_gamut                  "    HDR: Original/Vivid"                                      0.0      0.0   1.0      1.0
// #pragma parameter hcrt_lcd_resolution                "         Display's Resolution: 1080p | 4K | 8K"               1.0      0.0   2.0      1.0
// #pragma parameter hcrt_lcd_subpixel                  "         Display's Subpixel Layout: RGB | RWBG (OLED) | BGR"  0.0      0.0   2.0      1.0
#pragma parameter hcrt_space2                        " "                                                            0.0      0.0   0.0001   0.0001
#pragma parameter hcrt_developer_settings            "[ CRT SETTINGS ]:"                                            0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_title                         "[ --- SONY MEGATRON COLOUR VIDEO MONITOR --- ]"                    0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_crt_screen_type               "         Screen Type: APERTURE GRILLE | SHADOW MASK | SLOT MASK"   0.0      0.0   2.0      1.0
// #pragma parameter hcrt_crt_resolution                "         Resolution: 300TVL | 600TVL | 800TVL | 1000TVL"           1.0      0.0   3.0      1.0
#pragma parameter hcrt_colour_system                 "         Colour System: r709 | PAL | NTSC-U | NTSC-J"              2.0      0.0   3.0      1.0
#pragma parameter hcrt_white_temperature             "         White Temperature Offset (Kelvin)"                        0.0     -5000.0  12000.0      100.0
#pragma parameter hcrt_brightness                    "         Brightness"                                               0.0     -1.0   1.0      0.01
#pragma parameter hcrt_contrast                      "         Contrast"                                                 0.0     -1.0   1.0      0.01
#pragma parameter hcrt_saturation                    "         Saturation"                                               0.0     -1.0   1.0      0.01
#pragma parameter hcrt_gamma_in                      "         Gamma In"                                                 2.22     1.22  3.22     0.01
#pragma parameter hcrt_gamma_out                     "         Gamma Out"                                                2.4      2.0   2.8      0.005
// #pragma parameter hcrt_pin_phase                     "         Pin Phase"                                                0.00    -0.2   0.2      0.01
// #pragma parameter hcrt_pin_amp                       "         Pin Amp"                                                  0.00    -0.2   0.2      0.01
// #pragma parameter hcrt_space3                        " "                                                            0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_developer_settings0           "[ VERTICAL SETTINGS ]:"                                       0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_v_size                        "        Vertical Size"                                        1.00     0.8   1.2      0.01
// #pragma parameter hcrt_v_cent                        "        Vertical Center"                                      0.00  -200.0 200.0      1.0
// #pragma parameter hcrt_red_vertical_convergence      "        Red Vertical Deconvergence"                           0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_green_vertical_convergence    "        Green Vertical Deconvergence"                         0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_blue_vertical_convergence     "        Blue Vertical Deconvergence"                          0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_red_scanline_min              "        Red Scanline Min"                                     0.50     0.0   2.0      0.01 
// #pragma parameter hcrt_red_scanline_max              "        Red Scanline Max"                                     1.00     0.0   2.0      0.01 
// #pragma parameter hcrt_red_scanline_attack           "        Red Scanline Attack"                                  0.20     0.0   1.0      0.01
// #pragma parameter hcrt_green_scanline_min            "        Green Scanline Min"                                   0.50     0.0   2.0      0.01 
// #pragma parameter hcrt_green_scanline_max            "        Green Scanline Max"                                   1.00     0.0   2.0      0.01 
// #pragma parameter hcrt_green_scanline_attack         "        Green Scanline Attack"                                0.20     0.0   1.0      0.01
// #pragma parameter hcrt_blue_scanline_min             "        Blue Scanline Min"                                    0.50     0.0   2.0      0.01 
// #pragma parameter hcrt_blue_scanline_max             "        Blue Scanline Max"                                    1.00     0.0   2.0      0.01 
// #pragma parameter hcrt_blue_scanline_attack          "        Blue Scanline Attack"                                 0.20     0.0   1.0      0.01
// #pragma parameter hcrt_space4                        " "                                                            0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_developer_settings1           "[ HORIZONTAL SETTINGS ]:"                                     0.0      0.0   0.0001   0.0001
// #pragma parameter hcrt_h_size                        "        Horizontal Size"                                      1.00     0.8   1.2      0.01
// #pragma parameter hcrt_h_cent                        "        Horizontal Center"                                    0.00  -200.0 200.0      1.0
// #pragma parameter hcrt_red_horizontal_convergence    "        Red Horizontal Deconvergence"                         0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_green_horizontal_convergence  "        Green Horizontal Deconvergence"                       0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_blue_horizontal_convergence   "        Blue Horizontal Deconvergence"                        0.00     -10.0 10.0     0.01
// #pragma parameter hcrt_red_beam_sharpness            "        Red Beam Sharpness"                                   1.75     0.0   5.0      0.05
// #pragma parameter hcrt_red_beam_attack               "        Red Beam Attack"                                      0.50     0.0   2.0      0.01
// #pragma parameter hcrt_green_beam_sharpness          "        Green Beam Sharpness"                                 1.75     0.0   5.0      0.05
// #pragma parameter hcrt_green_beam_attack             "        Green Beam Attack"                                    0.50     0.0   2.0      0.01
// #pragma parameter hcrt_blue_beam_sharpness           "        Blue Beam Sharpness"                                  1.75     0.0   5.0      0.05
// #pragma parameter hcrt_blue_beam_attack              "        Blue Beam Attack"                                     0.50     0.0   2.0      0.01

#define HCRT_HDR                             params.hcrt_hdr
#define HCRT_COLOUR_ACCURATE                 params.hcrt_colour_accurate
#define HCRT_OUTPUT_COLOUR_SPACE             params.hcrt_colour_space
#define HCRT_CRT_COLOUR_SYSTEM               params.hcrt_colour_system
#define HCRT_MAX_NITS                        params.hcrt_max_nits
#define HCRT_PAPER_WHITE_NITS                params.hcrt_paper_white_nits
#define HCRT_EXPAND_GAMUT                    params.hcrt_expand_gamut
#define HCRT_GAMMA_OUT                       params.hcrt_gamma_out
#define HCRT_WHITE_TEMPERATURE              params.hcrt_white_temperature
#define HCRT_BRIGHTNESS                     params.hcrt_brightness
#define HCRT_CONTRAST                       params.hcrt_contrast
#define HCRT_SATURATION                     params.hcrt_saturation
#define HCRT_GAMMA_IN                       params.hcrt_gamma_in
#define HCRT_COLOUR_ACCURATE                params.hcrt_colour_accurate